function Figure1S3A()
% This script plots data from Figure 1 - figure supplement 3A for both
% replicates.

%==========================================================================
% Plot raw intensities from replicate 1:
load('488Fab_640Fab_rep1.mat')
[N,q] = hist3([log10(X)',log10(Y)'],'Nbins',[35 35]);
N = N./max(max(N));
 
v0 = [0.2:0.2:1];
figure; 
[M,junk] = contour(q{1},q{2},N'); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(X),log10(Y),xy(:,1),xy(:,2));
  X(in) = []; Y(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end
figure;
plot(log10(X),log10(Y),'.','Color',[0.5 0.5 0.5]); xlim([0 7]); ylim([0 7]); hold on;
contour(q{1},q{2},N'); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); 
plot([0 7],[0 7],':k'); axis square; drawnow;
title('Raw intensities, replicate 1');
xlabel('log10 D25(AF488) intensity');
ylabel('log10 D25(Cy5) intensity (raw)');
%==========================================================================

%==========================================================================
% Plot rescaled intensities from replicate 1:
load('488Fab_640Fab_rep1.mat')
Q = median(X./Y);
Y = Q*Y;
disp(['Calibration factor (rep.1): ',num2str(Q)]);
[N,q] = hist3([log10(X)',log10(Y)'],'Nbins',[35 35]);
N = N./max(max(N));
 
v0 = [0.2:0.2:1];
figure; 
[M,junk] = contour(q{1},q{2},N'); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(X),log10(Y),xy(:,1),xy(:,2));
  X(in) = []; Y(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end
figure;
plot(log10(X),log10(Y),'.','Color',[0.5 0.5 0.5]); xlim([0 7]); ylim([0 7]); hold on;
contour(q{1},q{2},N'); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); 
plot([0 7],[0 7],':k'); axis square; drawnow;
title('Calibrated intensities, replicate 1');
xlabel('log10 D25(AF488) intensity');
ylabel('log10 D25(Cy5) intensity (calibrated)');
%==========================================================================

%==========================================================================
% Plot raw intensities from replicate 2:
load('488Fab_640Fab_rep2.mat')
[N,q] = hist3([log10(X)',log10(Y)'],'Nbins',[35 35]);
N = N./max(max(N));
 
v0 = [0.2:0.2:1];
figure; 
[M,junk] = contour(q{1},q{2},N'); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(X),log10(Y),xy(:,1),xy(:,2));
  X(in) = []; Y(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end
figure;
plot(log10(X),log10(Y),'.','Color',[0.5 0.5 0.5]); xlim([0 7]); ylim([0 7]); hold on;
contour(q{1},q{2},N'); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); 
plot([0 7],[0 7],':k'); axis square; drawnow;
title('Raw intensities, replicate 2');
xlabel('log10 D25(AF488) intensity');
ylabel('log10 D25(Cy5) intensity (raw)');
%==========================================================================

%==========================================================================
% Plot rescaled intensities from replicate 2:
load('488Fab_640Fab_rep2.mat')
Q = median(X./Y);
Y = Q*Y;
disp(['Calibration factor (rep.2): ',num2str(Q)]);
[N,q] = hist3([log10(X)',log10(Y)'],'Nbins',[35 35]);
N = N./max(max(N));
 
v0 = [0.2:0.2:1];
figure; 
[M,junk] = contour(q{1},q{2},N'); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(X),log10(Y),xy(:,1),xy(:,2));
  X(in) = []; Y(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end
figure;
plot(log10(X),log10(Y),'.','Color',[0.5 0.5 0.5]); xlim([0 7]); ylim([0 7]); hold on;
contour(q{1},q{2},N'); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); 
plot([0 7],[0 7],':k'); axis square; drawnow;
title('Calibrated intensities, replicate 2');
xlabel('log10 D25(AF488) intensity');
ylabel('log10 D25(Cy5) intensity (calibrated)');
%==========================================================================

  